---
aliases:
  - biases
---
### Key types of biases
1.  **Confirmation bias** - we see what we want to see. Example: I’ve only heard great things about my manager, so the one person who had negative things to say must have had a bad performance review.
2.  **Attribution error** - we think other people’s behavior are driven by who they are. Example: They’re late because they’re unorganized, but I am late because I had to drop my kid off to school.
3.  **Overconfidence bias** - we overestimate our own abilities. Example: I trust my judgement and I know a winner when I see one. Let’s hire them!
4.  **Implicit association** - we use learned associations as shortcuts to categorize people. Unconsciously, we relate individuals or groups with media portrayals and cultural characterizations we have been submerged in our whole lives. Example: I know women and men are equally good at math and science. So why is it that when I envision an engineer, it’s always a man?


### 12 Cognitive Biases That Are Holding You Back

1. **Status Quo Bias**
   - Preferring things to stay the same.
   - **Example:** Resisting new software because the old one feels more comfortable, even if the new one is better.

2. **Confirmation Bias**
   - Favoring information that supports our beliefs.
   - **Example:** Paying attention only to the people in a group who agree with us, and giving more weight to their opinions.

3. **Anchoring Bias**
   - Relying too much on the first piece of information.
   - **Example:** Mentioning your previous salary in a new job negotiation may influence the final offer even though the position could justify a higher salary.

4. **Attribution Error**
   - Attributing others' actions to their character, not circumstances.
   - **Example:** Thinking a colleague is lazy for missing a deadline without considering what may be going on at home for them.

5. **Groupthink**
   - Conforming to the general opinion of the group over critical thinking out of fear of contradicting or being alienated.
   - **Example:** Agreeing with a risky investment just because the majority supports it.

6. **Hindsight Bias**
   - Overestimating how uncertain events were before they happened.
   - **Example:** Claiming you 'knew it all along' after a successful product launch, despite initial uncertainty.

7. **Availability Heuristic**
   - Judging events by how easily examples come to mind.
   - **Example:** Making disproportionate investments based on an overestimated likelihood of success.

8. **Framing Effect**
   - Conclusions are influenced by how information is presented.
   - **Example:** More employees support a project with a '90% success rate' than one with a '10% failure rate'.

9. **Halo Effect**
   - Letting overall impressions influence specific judgments.
   - **Example:** Assuming a charismatic CEO is more competent and trustworthy, regardless of their track record.

10. **Self-Serving Bias**
    - Attributing successes to oneself and failures to external factors.
    - **Example:** Crediting personal hard work for success but blaming market conditions for a failure.

11. **Negativity Bias**
    - Giving more weight to negative experiences.
    - **Example:** Being cynical and skeptical about innovations simply because they are new.

12. **Sunk Cost Fallacy**
    - Continuing to invest in something simply because we have already done it for a long time.
    - **Example:** Keep investing in a failing project to break-even or avoid acknowledging failure. 

By Benjamin Bargetzi